/*******************************************************************************
* Device      : AD18F08
* Author      : XAD SE Team
* Version     : V0.0.1
* Date        : 20220825
* Description : 系统外设驱动函数
********************************************************************************/

/********************************INCLUDES*************************************/
#include "Periph.h"

/*********************************************************/

void GPIO_INIT()
{
	PAOD = 0X00;
	PBOD = 0X00;

	PAPU = 0XFF;
	PBPU = 0XFF;	

	PAPD = 0XFF;
	PBPD = 0XFF;

	TRISA=0X00;	 	
	TRISB=0X00;	 	

	PORTA=0X00;	
	PORTB=0X00;

}
/***************************************************************
//Pch:0-PB6,1-PA3,2-PB4,3-PA0,4-DAC,5-ADC_MUX,6-FVR,7-GND
//Nch:0-PB7,1-PA5,2-PA2,3-PB2,4-DAC,5-ADC_MUX,6-FVR,7-PA1
//Mode<7>:  0-不输出到IO(PB6),1-输出到IO(PB6)
//Mode<6>:  0-不输出到IO(PB1),1-输出到IO(PB1)
//Mode<5>:  0-不输出到IO(PA5),1-输出到IO(PA5)
//Mode<4>:  0-不输出到IO(PA1),1-输出到IO(PA1)
//Mode<0>:  0-禁止,1-使能
****************************************************************/
void Cmp_Cfg(unsigned char Pch,unsigned char Nch,unsigned char Mode)
{
	if(Mode&0X01)
	{
		CMPCLKEN=1;

		CMPCON0=0X80;	//CMP使能
		//CMPPOS=0;	//不取反
		CMPCON0|=Pch<<3;	//同相端
		CMPCON0|=Nch;	//同相端

		CMPCON1=0<<6;	//下降沿迟滞，0-0mv,1-14mv,2-21mv,3-41mv
		CMPCON1|=0<<4;	//上身沿迟滞，0-0mv,1-12mv,2-18mv,3-38mv

		CMPCON2=0<<4;	//滤波时间：T=(CMPFILTER[3:0]<<4+15)/Fcpu，0-不滤波
		C0OUT0EN=1;
	
		if((Mode&0X80)==0x80)
		{
			C0OUT3EN=1;		//PB6输出
			PB6AEN=0;
			TRISB6=0;
			// PB6PD=1;
			// PB6PU=1;
		}
		else	
		{
			C0OUT3EN=0;	
		}

		if((Mode&0X40)==0x40)
		{
			C0OUT2EN=1;		//PB1输出
			TRISB1=0;
			// PB1PD=1;
			// PB1PU=1;
		}
		else
		{
			C0OUT2EN=0;		
		}

		if((Mode&0X20)==0x20)
		{
			C0OUT1EN=1;		//PA5输出
			TRISA5=0;
			// PA5PD=1;
			// PA5PU=1;
		}
		else	
		{
			C0OUT1EN=0;		
		}

		if((Mode&0X10)==0x10)
		{
			C0OUT0EN=1;		//PA1输出
			TRISA1=0;
			// PA1PD=1;
			// PB7PU=1;
		}
		else
		{
			C0OUT0EN=0;
		}
	}
	else
	{
		CMPCLKEN=0;
		CMPCON0=0X00;
	}
	
}

